//
//  MCBackgroundProgramUtilities.h
//  MCClientServer
//
//  Created by Fraser Kuyvenhoven on 11/19/08.
//  Copyright 2008 Marketcircle. All rights reserved.
//


#import <Foundation/Foundation.h>
#import <Security/Authorization.h>


// Errors
extern NSString* MCBackgroundProgramDomain;

typedef enum {
	
	MCBackgroundProgramDaemonCheckError = 100,
	MCBackgroundProgramDaemonLoadError = 101,
	MCBackgroundProgramDaemonUnloadError = 102,
	
	MCBackgroundProgramAgentCheckError = 200,
	MCBackgroundProgramAgentLoadError = 201,
	MCBackgroundProgramAgentUnloadError = 202,

	MCBackgroundProgramFixPermissionsError = 300,
	MCBackgroundProgramNoJobLabelError = 301

} MCBackgroundProgramErrorCode;


// This is implemented in MCDaemonKeeper.m
extern NSString* MCServerPathForTool(NSString* tool);


@interface MCBackgroundProgramUtilities : NSObject
{
}

// Daemons

+ (NSString *)launchDaemonsPlistFolderPath;

+ (NSString *)launchCtlAuthPath;

+ (BOOL)checkLaunchDaemonLoadedWithPlist:(NSDictionary *)plist error:(NSError **)error;

+ (BOOL)loadLaunchDaemonForPlist:(NSDictionary *)plist error:(NSError **)error;
+ (BOOL)unloadLaunchDaemonForPlist:(NSDictionary *)plist error:(NSError **)error;

// Daemons (with authorization)

+ (BOOL)checkLaunchDaemonLoadedWithPlist:(NSDictionary *)plist authorization:(AuthorizationRef)authorization error:(NSError **)error;

+ (BOOL)loadLaunchDaemonForPlist:(NSDictionary *)plist authorization:(AuthorizationRef)authorization error:(NSError **)error;
+ (BOOL)unloadLaunchDaemonForPlist:(NSDictionary *)plist authorization:(AuthorizationRef)authorization error:(NSError **)error;

// Agents

+ (NSString *)launchAgentsPlistFolderPath;

+ (BOOL)checkLaunchAgentLoadedWithPlist:(NSDictionary *)plist errorString:(NSString **)errorString;

+ (BOOL)loadLaunchAgentForPlist:(NSDictionary *)plist errorString:(NSString **)errorString;
+ (BOOL)unloadLaunchAgentForPlist:(NSDictionary *)plist errorString:(NSString **)errorString;

// Extra

+ (BOOL)repairPermissions:(NSError **)error;

@end
